<?php
/**
 * Admin Message Management API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = requireAdmin();

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    // Delete message
    $data = json_decode(file_get_contents("php://input"));

    if (empty($data->message_id)) {
        sendResponse('error', 'Message ID is required', null, 400);
    }

    try {
        $database = new Database();
        $conn = $database->getConnection();

        // Soft delete
        $query = "UPDATE messages SET is_deleted = 1 WHERE id = :message_id";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':message_id', $data->message_id);

        if ($stmt->execute()) {
            // Log activity
            $log_query = "INSERT INTO activity_logs (user_id, activity_type, description, ip_address) 
                          VALUES (:admin_id, 'admin_action', :description, :ip)";
            $log_stmt = $conn->prepare($log_query);
            $description = "Admin deleted message ID: {$data->message_id}";
            $log_stmt->bindParam(':admin_id', $user['id']);
            $log_stmt->bindParam(':description', $description);
            $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
            $log_stmt->execute();

            sendResponse('success', 'Message deleted successfully', null, 200);
        } else {
            sendResponse('error', 'Failed to delete message', null, 500);
        }

    } catch (PDOException $e) {
        sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
    }

} else {
    sendResponse('error', 'Method not allowed', null, 405);
}
?>
