<?php
/**
 * React to Announcement API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = authenticate();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed', null, 405);
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->announcement_id) || empty($data->reaction_type)) {
    sendResponse('error', 'Announcement ID and reaction type are required', null, 400);
}

$allowed_reactions = ['like', 'love', 'support', 'celebrate'];
if (!in_array($data->reaction_type, $allowed_reactions)) {
    sendResponse('error', 'Invalid reaction type', null, 400);
}

try {
    $database = new Database();
    $conn = $database->getConnection();

    $query = "INSERT INTO announcement_reactions (announcement_id, user_id, reaction_type) 
              VALUES (:announcement_id, :user_id, :reaction_type)
              ON DUPLICATE KEY UPDATE reaction_type = :reaction_type";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':announcement_id', $data->announcement_id);
    $stmt->bindParam(':user_id', $user['id']);
    $stmt->bindParam(':reaction_type', $data->reaction_type);
    
    if ($stmt->execute()) {
        sendResponse('success', 'Reaction added', null, 200);
    } else {
        sendResponse('error', 'Failed to add reaction', null, 500);
    }

} catch (PDOException $e) {
    sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
}
?>
