<?php
/**
 * Add Reaction to Message API
 */

// Define the root path of the project
define('ROOT_PATH', realpath(__DIR__ . '/../../..'));

require_once ROOT_PATH . '/backend/api/cors.php';
handleCORS();

require_once ROOT_PATH . '/backend/config/database.php';
require_once ROOT_PATH . '/backend/config/config.php';
require_once ROOT_PATH . '/backend/middleware/auth.php';

$user = authenticate();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse('error', 'Method not allowed', null, 405);
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->message_id) || empty($data->emoji)) {
    sendResponse('error', 'Message ID and emoji are required', null, 400);
}

try {
    $database = new Database();
    $conn = $database->getConnection();

    // Insert or update reaction
    $query = "INSERT INTO message_reactions (message_id, user_id, reaction_emoji) 
              VALUES (:message_id, :user_id, :emoji)
              ON DUPLICATE KEY UPDATE reaction_emoji = :emoji";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':message_id', $data->message_id);
    $stmt->bindParam(':user_id', $user['id']);
    $stmt->bindParam(':emoji', $data->emoji);
    
    if ($stmt->execute()) {
        sendResponse('success', 'Reaction added', null, 200);
    } else {
        sendResponse('error', 'Failed to add reaction', null, 500);
    }

} catch (PDOException $e) {
    sendResponse('error', 'Database error: ' . $e->getMessage(), null, 500);
}
?>
