<?php
/**
 * Authentication Middleware
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/config.php';

function authenticate() {
    $headers = getallheaders();
    
    if (!isset($headers['Authorization'])) {
        sendResponse('error', 'No authorization token provided', null, 401);
    }

    $token = str_replace('Bearer ', '', $headers['Authorization']);

    try {
        $database = new Database();
        $conn = $database->getConnection();

        $query = "SELECT u.id, u.username, u.email, u.full_name, u.profile_picture, u.role, u.is_active 
                  FROM user_sessions s
                  JOIN users u ON s.user_id = u.id
                  WHERE s.session_token = :token 
                  AND s.expires_at > CURRENT_TIMESTAMP
                  AND u.is_active = 1";
        
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':token', $token);
        $stmt->execute();

        if ($stmt->rowCount() === 0) {
            sendResponse('error', 'Invalid or expired token', null, 401);
        }

        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Update online status
        $online_query = "INSERT INTO online_users (user_id) VALUES (:user_id) 
                         ON DUPLICATE KEY UPDATE last_activity = CURRENT_TIMESTAMP";
        $online_stmt = $conn->prepare($online_query);
        $online_stmt->bindParam(':user_id', $user['id']);
        $online_stmt->execute();

        return $user;

    } catch (PDOException $e) {
        sendResponse('error', 'Authentication failed', null, 500);
    }
}

function requireAdmin() {
    $user = authenticate();
    
    if ($user['role'] !== 'admin' && $user['role'] !== 'moderator') {
        sendResponse('error', 'Admin or moderator access required', null, 403);
    }

    return $user;
}
?>
